<?php
set_time_limit(0);
ini_set('memory_limit', '-1');
require_once("includes/config.php");
require_once("includes/sendgrid/sendgrid-php.php");
require_once("includes/etsyv3/vendor/autoload.php");
$logfile = fopen("logs/fetchetsyproductsfirst-".date('Y-m-d').".txt", "a+") or die("Unable to open log file!");
addlog("Execution Started", "INFO");
use OAuth\Client;
echo "start ";
$user_id;
if($argv[1]){
	$user_id = $argv[1];
	addlog("user_id is for fetchetsyproductfirsts : ".$user_id);
	die();
}else{
	exit();
}



		echo $user_id;
		$configResult = $conn->query("select * from etsy_keys where valid = 1 and user_id  != 561 and user_id = ".$user_id);
		if ($configResult->num_rows > 0) {
			echo "test valid";
			$configRow = $configResult->fetch_assoc();
			$shop_id = $configRow['shop_id'];
			$access_token = $configRow['access_token'];
			$refresh_token = $configRow['refresh_token'];
			$api_key = $etsyConfig['api_key'];

			$existingSKUs = array();
			$result = $conn->query("select distinct etsylistingid from products where user_id = " . $user_id);
			if ($result->num_rows > 0) {
				while ($row = $result->fetch_assoc()) {
					$existingSKUs[] = $row['etsylistingid'];
				}
			}

			addlog("Process started for user_id - " . $user_id, "INFO");
			fetchCatalog($user_id, $shop_id, $access_token, $refresh_token, $existingSKUs, $api_key);
			$conn->query("update etsy_requests set inprocess = 0, status = 'completed' where user_id = " . $user_id . " and id = " . $queueRow['id']);
			$conn->query("update etsy_keys set lastdatafetched = now() where user_id = " . $user_id);						
			if($user_id == 563  || $user_id == 2865){
				$conn->query("update products set status = 'Import in progress' WHERE user_id = ".$user_id." and status = 'Ready to Import'");
			}
			if($user_id == 1029 || $user_id == 1217 || $user_id == 1087  || $user_id == 2422 || $user_id == 2563){
				$conn->query("update products set status = 'Import in progress' WHERE user_id = ".$user_id." and status = 'Ready to Import'");
			}
			sendEmail($user_id);
		} else {
			addlog("No valid Etsy keys found. user_id - " . $user_id, "ERROR");
		}
	
$conn->query("update crons set isrunning = 0 where crontype = 'fetchetsyproduct_v3'");
function fetchCatalog($user_id, $shop_id, $access_token, $refresh_token, $existingSKUs, $api_key)
{
	global $conn;

	echo $shop_id;
	$header = array("Authorization: Bearer " . $access_token, "x-api-key: " . $api_key);
	try {
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://openapi.etsy.com/v3/application/shops/' . $shop_id . '/listings?state=active&limit=100&offset=0',
			CURLOPT_HTTPHEADER => $header,
			CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_RETURNTRANSFER => true
		));
		$r_body = curl_exec($curl);
		curl_close($curl);
		$r = json_decode($r_body);
		print_r($r);
		if (isset($r->error) && $r->error == 'invalid_token') {
			try{
			
				echo "check refreshtoken";
				
				$tokenResponse = etsyRefreshToken($refresh_token);
				addlog("refresh token   ".json_encode($tokenResponse)."","INFO");
				print_r($tokenResponse);
				// die();
				// die($tokenResponse);
				if (isset($tokenResponse['access_token'])) {
					$access_token =$tokenResponse['access_token'];
					$refresh_token =$tokenResponse['refresh_token'];
					print_r($tokenResponse);
					fetchCatalog($user_id, $shop_id, $access_token, $refresh_token, $existingSKUs, $api_key);
				}else{
					$conn->query("update etsy_requests set inprocess = 0, status = 'completed' where user_id = " . $user_id);
					echo "user for refresh token ".$user_id;
					addlog("refresh token is expire for user ".$user_id,"INFO");
					return;
				}
			}

			catch (OAuthException $e) {
				print_r($e);

				addlog(" error".$e->getMessage()."","");
				// error_log($e->getMessage());
				// error_log(print_r($oauth->getLastResponse(), true));
				// error_log(print_r($oauth->getLastResponseInfo(), true));
			}
			echo "hello";
			$client = new Etsy\OAuth\Client($api_key);
		//	print_r($client);
			$refreshTokenArray = $client->refreshAccessToken($refresh_token);
			print_r($refreshTokenArray);
			if (isset($refreshTokenArray->access_token)) {
				$access_token = $refreshTokenArray->access_token;
				$refresh_token = $refreshTokenArray->refresh_token;
			
				
				$conn->query("update etsy_keys set access_token = '" . mysqli_real_escape_string($conn, $access_token) . "',refresh_token = '" . mysqli_real_escape_string($conn, $refresh_token) . "', updated_at = now() where user_id = " . $user_id);
				fetchCatalog($user_id, $shop_id, $access_token, $refresh_token, $existingSKUs, $api_key);
			}
		} else {
			insertProducts($user_id, $shop_id, $access_token, $refresh_token, $existingSKUs, $api_key, $r);
		}
	} catch (OAuthException $e) {
		print_r($e);
		error_log($e->getMessage());
		error_log(print_r($oauth->getLastResponse(), true));
		error_log(print_r($oauth->getLastResponseInfo(), true));
	}
}

function etsyRefreshToken($refreshToken){
	$clientId = '9vnyhcjjd9p6q4m239g9brio';

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://api.etsy.com/v3/public/oauth/token");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
		'grant_type' => 'refresh_token',
		'refresh_token' => $refreshToken,
		'client_id' => $clientId,
	]));

	$response = curl_exec($ch);
	curl_close($ch);


	$data = json_decode($response, true);
	return $data;


}
function insertProducts($user_id, $shop_id, $access_token, $refresh_token, $existingSKUs, $api_key, $r)
{
	global $conn;
	$header = array("Authorization: Bearer " . $access_token, "x-api-key: " . $api_key);
	try {
		if ($r->count > 0) {
			$c = $r->count;
			$c = $c / 100;
			$c = intval($c);
			$c = $c + 1;
			for ($q = 0; $q <= $c; $q++) {
				$offset = $q * 100;

				$curl = curl_init();
				curl_setopt_array($curl, array(
					CURLOPT_URL => 'https://openapi.etsy.com/v3/application/shops/' . $shop_id . '/listings?state=active&includes=Translations&limit=100&offset=' . $offset,
					CURLOPT_HTTPHEADER => $header,
					CURLOPT_SSL_VERIFYPEER => false,
					CURLOPT_RETURNTRANSFER => true
				));
				$response_body = curl_exec($curl);
				curl_close($curl);
				echo $response_body;
				$response = json_decode($response_body);

				if ($response->results != '') {
					foreach ($response->results as $listing) {
						if (!isset($listing->listing_id)) {
							// TODO: Listing id missing
							continue;
						}
						$etsy_listing_id = $listing->listing_id;
						if (in_array($etsy_listing_id, $existingSKUs)) {
							// TODO: Listing id already exists
							continue;
						}
						$title = "";
						$description = "";
						$tags = "";
						$materials = "";
						$who_made = "";
						$is_supply = "";
						$when_made = "";
						$section_id = "";
						$section_name = "";
						$images = array();
						$category_path = "";
						$etsy_state = "";
						$weight ="0";
						$weight_unit="";
						$variations = array();
						print_r("etsy listing id ".$etsy_listing_id);
						if (isset($listing->title)) {
							$title = $listing->title;
						}

						if (isset($listing->description)) {
							$description = $listing->description;
						}
						if (isset($listing->item_weight_unit)) {
							$weight_unit =$listing->item_weight_unit;
						}
						if (isset($listing->item_weight)) {
							if($weight_unit == 'oz' &&  $listing->item_weight >= 16){
								$weight  =$listing->item_weight * 0.0625;
								$weight_unit = 'lb';
							}
							else{
								$weight  =$listing->item_weight;
							}
						}
						$tagsArr = array();
						if (isset($listing->tags)) {
							$tagsLength = count($listing->tags);
							for ($i = 0; $i < $tagsLength; $i++) {
								$tagsArr[] = $listing->tags[$i];
							}
						}


						$tags = implode(", ", $tagsArr);

						$materialsArr = array();
						if (isset($listing->materials)) {
							$materialsLength = count($listing->materials);
							for ($i = 0; $i < $materialsLength; $i++) {
								$materialsArr[] = $listing->materials[$i];
							}
						}
						$materials = implode(", ", $materialsArr);

						if (isset($listing->who_made)) {
							$who_made = $listing->who_made;
						}
						if (isset($listing->is_supply)) {
							$is_supply = $listing->is_supply;
						}
						if (isset($listing->when_made)) {
							$when_made = $listing->when_made;
						}

						$arr = array('materials' => $materials, 'who_made' => $who_made, 'is_supply' => $is_supply, 'when_made' => $when_made);
						$attributes  = json_encode($arr);

						//if (isset($listing->Section)) {
							$section_id = $listing->shop_section_id;
						//}
						if ($section_id != "") {
							$section_name = getSectionName($user_id, $access_token, $refresh_token, $shop_id, $section_id);
						}

						$category = array();
						if (isset($listing->category_path)) {
							$category_pathLength = count($listing->category_path);
							for ($i = 0; $i < $category_pathLength; $i++) {
								$category[] = $listing->category_path[$i];
							}
						}
						$category_path = implode(", ", $category);
						if (isset($listing->state)) {
							$etsy_state = $listing->state;
						}

						$curl = curl_init();
						curl_setopt_array($curl, array(
							CURLOPT_URL => 'https://openapi.etsy.com/v3/application/shops/' . $shop_id . '/listings/' . $etsy_listing_id . '/images',
							CURLOPT_HTTPHEADER => $header,
							CURLOPT_SSL_VERIFYPEER => false,
							CURLOPT_RETURNTRANSFER => true
						));
						$image_body = curl_exec($curl);
						curl_close($curl);
						$imgResponse = json_decode($image_body);

						if ($imgResponse != "") {
							if (isset($imgResponse->results)) {
								$pictureLength = count($imgResponse->results);
								for ($i = 0; $i < $pictureLength; $i++) {
									if (isset($imgResponse->results[$i]->url_fullxfull)) {
										$images[] = $imgResponse->results[$i]->url_fullxfull;
									} else if (isset($imgResponse->results[$i]->url_570xN)) {
										$images[] = $imgResponse->results[$i]->url_570xN;
									} else if (isset($imgResponse->results[$i]->url_170x135)) {
										$images[] = $imgResponse->results[$i]->url_170x135;
									} else if (isset($imgResponse->results[$i]->url_75x75)) {
										$images[] = $imgResponse->results[$i]->url_75x75;
									} else {
										$images[] = array();
									}
								}
							}
						}

						if ($listing->has_variations == 1) {
							$curl = curl_init();
							curl_setopt_array($curl, array(
								CURLOPT_URL => 'https://openapi.etsy.com/v3/application/listings/' . $etsy_listing_id . '/inventory',
								CURLOPT_HTTPHEADER => $header,
								CURLOPT_SSL_VERIFYPEER => false,
								CURLOPT_RETURNTRANSFER => true
							));
							$response_body1 = curl_exec($curl);
							curl_close($curl);
							$variation = json_decode($response_body1);

							if ($variation != "") {
								if (isset($variation->products)) {
									$varLength = count($variation->products);
									for ($i = 0; $i < $varLength; $i++) {
										if (isset($variation->products[$i]->product_id)) {
											$variations[$i]['sku'] = $variation->products[$i]->sku;
										} else {
											$variations[$i]['sku'] = "";
										}
										if (isset($variation->products[$i]->property_values[0]->property_name)) {
											$variations[$i]['option1name'] = $variation->products[$i]->property_values[0]->property_name;
										} else {
											$variations[$i]['option1name'] = "";
										}

										if (isset($variation->products[$i]->property_values[0]->values[0])) {
											$variations[$i]['option1val'] = $variation->products[$i]->property_values[0]->values[0];
										} else {
											$variations[$i]['option1val'] = "";
										}

										if (isset($variation->products[$i]->property_values[1]->property_name)) {
											$variations[$i]['option2name'] = $variation->products[$i]->property_values[1]->property_name;
										} else {
											$variations[$i]['option2name'] = "";
										}

										if (isset($variation->products[$i]->property_values[1]->values[0])) {
											$variations[$i]['option2val'] = $variation->products[$i]->property_values[1]->values[0];
										} else {
											$variations[$i]['option2val'] = "";
										}

										if (isset($variation->products[$i]->offerings[0]->price->amount)) {
											$variations[$i]['price'] = $variation->products[$i]->offerings[0]->price->amount / $variation->products[$i]->offerings[0]->price->divisor;
											
										} else {
											$variations[$i]['price'] = "";
										}

										if (isset($variation->products[$i]->offerings[0]->quantity)) {
											$variations[$i]['quantity'] = $variation->products[$i]->offerings[0]->quantity;
										} else {
											$variations[$i]['quantity'] = "";
										}
									}
								}

								$productQuery = "INSERT INTO products(title, description, tags, attributes, section_id, section_name, category_path, etsylistingid, etsy_state, option1name, option2name, user_id, created_at, updated_at) VALUES('" . mysqli_real_escape_string($conn, $title) . "', '" . mysqli_real_escape_string($conn, $description) . "', '" . mysqli_real_escape_string($conn, $tags) . "', '" . mysqli_real_escape_string($conn, $attributes) . "', '" . mysqli_real_escape_string($conn, $section_id) . "', '" . mysqli_real_escape_string($conn, $section_name) . "', '" . mysqli_real_escape_string($conn, $category_path) . "', '" . mysqli_real_escape_string($conn, $etsy_listing_id) . "', '" . mysqli_real_escape_string($conn, $etsy_state) . "', '" . mysqli_real_escape_string($conn, $variations[0]['option1name']) . "', '" . mysqli_real_escape_string($conn, $variations[0]['option2name']) . "', '" . $user_id . "', now(), now())";
								$productResult = mysqli_query($conn, $productQuery);
								$product_id = $conn->insert_id;

								foreach ($variations as $productVariant) {
									$productVariantQuery = "insert into product_variants(product_id, sku, option1val, option2val, price, quantity, user_id, created_at, updated_at, weight, weight_unit) VALUES('" . mysqli_real_escape_string($conn, $product_id) . "', '" . mysqli_real_escape_string($conn, $productVariant['sku']) . "', '" . mysqli_real_escape_string($conn, $productVariant['option1val']) . "', '" . mysqli_real_escape_string($conn, $productVariant['option2val']) . "', '" . mysqli_real_escape_string($conn, $productVariant['price']) . "', '" . mysqli_real_escape_string($conn, $productVariant['quantity']) . "', '" . $user_id . "', now(), now(),'" . mysqli_real_escape_string($conn, $weight) . "','" . mysqli_real_escape_string($conn, $weight_unit) . "')";
									$productVariantResult = mysqli_query($conn, $productVariantQuery);
								}
								unset($variations);
								if (!empty($images)) {
									foreach ($images as $imgurl) {
										$productImageQuery = "INSERT INTO product_images(product_id, imgurl, user_id, created_at, updated_at) VALUES('" . mysqli_real_escape_string($conn, $product_id) . "', '" . mysqli_real_escape_string($conn, $imgurl) . "', '" . $user_id . "', now(), now())";
										$productImageResult = mysqli_query($conn, $productImageQuery);
									}
								}
							}
						} else {
							$price = 0.0;
							$quantity = 0;
							$sku = "";
							if (isset($listing->price)) {
								if (isset($listing->price->amount)) {
									$price = $listing->price->amount / $listing->price->divisor;
								}
							}
							if (isset($listing->quantity)) {
								$quantity = $listing->quantity;
							}
							if (isset($listing->skus[0])) {
								$sku = $listing->skus[0];
							}
							$productQuery = "INSERT INTO products(title, description, tags, attributes, section_id, section_name, category_path, etsylistingid, etsy_state, user_id, created_at, updated_at) VALUES('" . mysqli_real_escape_string($conn, $title) . "', '" . mysqli_real_escape_string($conn, $description) . "', '" . mysqli_real_escape_string($conn, $tags) . "', '" . mysqli_real_escape_string($conn, $attributes) . "', '" . mysqli_real_escape_string($conn, $section_id) . "', '" . mysqli_real_escape_string($conn, $section_name) . "', '" . mysqli_real_escape_string($conn, $category_path) . "', '" . mysqli_real_escape_string($conn, $etsy_listing_id) . "', '" . mysqli_real_escape_string($conn, $etsy_state) . "', '" . $user_id . "', now(), now())";
							$productResult = mysqli_query($conn, $productQuery);
							$product_id = $conn->insert_id;

							

							$productVariantQuery = "insert into product_variants(product_id, sku, price, quantity, user_id, created_at, updated_at, weight, weight_unit) VALUES('" . mysqli_real_escape_string($conn, $product_id) . "', '" . mysqli_real_escape_string($conn, $sku) . "', '" . mysqli_real_escape_string($conn, $price) . "', '" . mysqli_real_escape_string($conn, $quantity) . "', '" . $user_id . "', now(), now(),'" . mysqli_real_escape_string($conn, $weight) . "','" . mysqli_real_escape_string($conn, $weight_unit) . "')";
							$productVariantResult = mysqli_query($conn, $productVariantQuery);
							$variant_id = $conn->insert_id;

							if (!empty($images)) {
								foreach ($images as $imgurl) {
									$productImageQuery = "INSERT INTO product_images(variant_id, product_id, imgurl, user_id, created_at, updated_at) VALUES('" . mysqli_real_escape_string($conn, $variant_id) . "','" . mysqli_real_escape_string($conn, $product_id) . "', '" . mysqli_real_escape_string($conn, $imgurl) . "', '" . $user_id . "', now(), now())";
									$productImageResult = mysqli_query($conn, $productImageQuery);
								}
							}
						}
					}
				}
			}
		}
	} catch (OAuthException $e) {
		print_r($e);
		error_log($e->getMessage());
		error_log(print_r($oauth->getLastResponse(), true));
		error_log(print_r($oauth->getLastResponseInfo(), true));
	}
}

function sendEmail($user_id)
{
	global $conn;
	$result = $conn->query("select count(*) as cnt from etsy_requests where status = 'completed' and user_id = " . $user_id);
	$row = $result->fetch_assoc();
	if ($row['cnt'] == 1) {
		$userResult = $conn->query("select ownername, email, shopurl, token from users where id = " . $user_id);
		if ($userResult->num_rows > 0) {			
			$settingsResult = $conn->query("select * from settings where user_id = " . $user_id);
			if ($settingsResult->num_rows < 1) {
				$conn->query("insert into setting(user_id, published, tags, inventory_sync, price_sync, created_at, updated_at) values (" . $user_id . ", 1, '', 0, 0, now(), now())");
			}
			while ($userRow = $userResult->fetch_assoc()) {
				$to = $userRow['email'];
				$name = $userRow['ownername'];				
				if (strlen($to) < 1) {
					return;
				}
				$subject = "[Shopify APP] Etsy  Importer - Setup completed";
				$body = '<p>Dear '.$name.',</p>
					<p>We\'re thrilled to inform you that your account setup is complete, and we\'ve successfully fetched Etsy products into our app!</p>
					<h3>Import Etsy Products to Your Shopify Store</h3>
                     <p>You can now log into the app and start importing products to your Shopify store in the <strong>Products</strong> section.</p>
					 <h3>Helpful Resources</h3>
					 <ul>
                       <li><strong>Tutorial</strong>: For step-by-step guidance on how to import products, <a href="https://infoshoreapps.freshdesk.com/support/solutions/articles/36000156808-etsy-importer-how-to-add-products-to-your-shopify-store" target="_blank">click here</a> to access our helpful tutorial.</li>
                       <li><strong>Video Guide</strong>: We also have a detailed video that explains how to import your first product—perfect for getting you started quickly!</li>
                     </ul>
					  <h3>We\'re Here for You</h3>
                      <p>If you have any questions or need assistance, please don\'t hesitate to reach out. Simply reply to this email, and we\'ll be happy to help!</p>
					  <p><strong>Best regards,<br>Pankaj Narang<br>InfoShore Apps</strong></p>
                      <p>Skype: pankaj.narang</p>
					  <a href="https://direct.lc.chat/18704628/" target="_blank">Start the live chat</a>
					';
					$email = new \SendGrid\Mail\Mail(); 
                    $email->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
                    $email->setSubject($subject);
                    $email->addTo($to);
                    $email->addBcc("pankajnarang81@gmail.com");
                    $email->addContent(
                        "text/html", $body
                    );
                    $sendgrid = new \SendGrid('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');
                    try {
                        $response = $sendgrid->send($email);
						
						addlog("welcome email has been sent to use epi ", "INFO");
                        return true;
                    } catch (Exception $e) {
                        @mail("pankajnarang81@gmail.com", "Fetchetsyproducts: Error sending setup email", 'A sendgrid error occurred: '.$e->getMessage());
                        return false;
                    }
			}
		}
	}
}

function sendGridEmail($to, $subject, $body)
{
	require_once("includes/sendgrid/sendgrid-php.php");
	$email = new \SendGrid\Mail\Mail();
	$email->setFrom("shopifyapps@infoshore.biz", "Rohit from InfoshoreApps");
	$email->setSubject($subject);
	$email->addTo($to);
	$email->addBcc("khariwal.rohit@gmail.com");
	$email->addContent(
		"text/html",
		$body
	);
	$sendgrid = new \SendGrid('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');
	try {
		$sendgrid->send($email);
		return true;
	} catch (Exception $e) {		
		return false;
	}
}

function getSectionName($user_id, $access_token, $refresh_token, $shop_id, $section_id)
{
	global $conn, $etsyConfig;
	$section_name = "";
	$sResult = $conn->query("SELECT * FROM `etsy_section` where shop_section_id = '" . $section_id . "'");
	if ($sResult->num_rows > 0) {
		$sRow = $sResult->fetch_assoc();
		$section_name = $sRow["title"];
	} else {
		$api_key = $etsyConfig['api_key'];
		$header = array("Authorization: Bearer " . $access_token, "x-api-key: " . $api_key);
		try {
			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => 'https://openapi.etsy.com/v3/application/shops/' . $shop_id . '/sections',
				CURLOPT_HTTPHEADER => $header,
				CURLOPT_SSL_VERIFYPEER => false,
				CURLOPT_RETURNTRANSFER => true
			));
			$r_body = curl_exec($curl);
			curl_close($curl);
			$r = json_decode($r_body, true);
			if (isset($r->error) && $r->error == 'invalid_token') {
				$client = new Etsy\OAuth\Client($api_key);
				$refreshTokenArray = $client->refreshAccessToken($refresh_token);
				if (isset($refreshTokenArray['access_token'])) {
					$access_token = $refreshTokenArray['access_token'];
					$refresh_token = $refreshTokenArray['refresh_token'];
					$conn->query("update etsy_keys set access_token = '" . mysqli_real_escape_string($conn, $refreshTokenArray['access_token']) . "',refresh_token = '" . mysqli_real_escape_string($conn, $refreshTokenArray['refresh_token']) . "', updated_at = now() where user_id = " . $user_id);
					$header = array("Authorization: Bearer " . $access_token, "x-api-key: " . $api_key);
					$curl = curl_init();
					curl_setopt_array($curl, array(
						CURLOPT_URL => 'https://openapi.etsy.com/v3/application/shops/' . $shop_id . '/sections',
						CURLOPT_HTTPHEADER => $header,
						CURLOPT_SSL_VERIFYPEER => false,
						CURLOPT_RETURNTRANSFER => true
					));
					$r_body = curl_exec($curl);
					curl_close($curl);
					$r = json_decode($r_body, true);
					insertSections($user_id, $r);
				}
			} else {
				insertSections($user_id, $r);
			}
			$sResult = $conn->query("SELECT * FROM `etsy_section` where shop_section_id = '" . $section_id . "'");
			if ($sResult->num_rows > 0) {
				$sRow = $sResult->fetch_assoc();
				$section_name = $sRow["title"];
			}
		} catch (OAuthException $e) {
			print_r($e);
			error_log($e->getMessage());
			error_log(print_r($oauth->getLastResponse(), true));
			error_log(print_r($oauth->getLastResponseInfo(), true));
		}
	}
	return $section_name;
}

function insertSections($user_id, $r)
{
	global $conn;
	if ($r["count"] > 0) {
		if ($r["results"] != '') {
			foreach ($r["results"] as $section) {
				$shop_section_id = $section["shop_section_id"];
				$sResult = $conn->query("SELECT * FROM `etsy_section` where shop_section_id = " . $shop_section_id);
				if ($sResult->num_rows > 0) {
					continue;
				}
				$title = $section["title"];
				$etsy_user_id = $section["user_id"];
				$conn->query("insert into etsy_section(shop_section_id, title, etsy_user_id, user_id) values ('" . mysqli_real_escape_string($conn, $shop_section_id) . "','" . mysqli_real_escape_string($conn, $title) . "','" . mysqli_real_escape_string($conn, $etsy_user_id) . "','" . mysqli_real_escape_string($conn, $user_id) . "')");
			}
		}
	}
}

function addlog($message, $type="INFO")
{
	global $logfile;
	$txt = date("Y-m-d H:i:s") . " [" . $type . "]: " . $message . "\n";
	fwrite($logfile, $txt);
}
addlog("Execution Finished", "INFO");
fclose($logfile);
?>